clear all
%% reading files
file_list = dir('*.fig');

ind = length(file_list) ;
for i_a=1:ind
    fig = openfig(file_list(i_a).name);
    fig = gcf;
    M{i_a} = getimage(fig);
    close(fig)
end
%%
for u=1:ind
    Mm = M{u};
    f1 = fspecial('Gaussian',6,2);
    Mm= imfilter(Mm,f1,'replicate');
    if length(Mm(1,:))>72
        Mm = Mm(:,1:72);
    end
    mks = sort(Mm(:));
    thm = mks(end);
    ths = mean(mks(end-length(mks)/100:end));
    %th = ths/thm;
    %th = graythresh(Mm);
    th =  0.1;
    %th=0.006;
    Mmn = Mm./ths;
    BW = im2bw(Mmn,th);
    BW=imfill(BW,'holes');
    se=strel('disk',3);
    BW = imerode(BW,se);
    mBW = bwareaopen(BW,100);
    imshow(BW)
    drawnow
    pause(0.2)
    bins = 10;
    si = size(Mm);
    for i=1:si(2)-bins
        BWloc = BW(:,i:i+bins);
        CC = bwconncomp(BWloc);
        NP(i)=CC.NumObjects;
        if sum(BWloc(1,:))>=1&sum(BWloc(end,:))>=1
            NP(i)=NP(i)-1;
        end
    end    
    up(u) = mean(NP);
end

% mean(up)
% std(up)

x = [repmat(1,length(up),1)]';
uni = x./up;

unicity = mean(uni)
unicitySD = std(uni)
save('uni.mat','uni')
%%
load('resmatrix3p025.mat')
load('uni.mat')
%param
pu = mean(uni);
pusd = std(uni);
pusm = std(uni)/sqrt(31);
pu2 = 0.63;
pusd2 = 0.12;
pusm2 = 0.12/sqrt(17);
pt = 2.3;
ptsm = 1.4/sqrt(17);
pt2 = 0.68;
ptsm2 = 1.7/sqrt(31);

[X,Y] = meshgrid(0:0.1:1);
[Xq,Yq] = meshgrid(0:0.01:1);
XX = 0:0.01:1;
f1 = fspecial('Gaussian',5,1);
S1= imfilter(RES1b,f1,'replicate');
S2= imfilter(1./RES2,f1,'replicate');
S3= imfilter(RES3,f1,'replicate');
V1q = interp2(X,Y,S1,Xq,Yq);
V1f = rot90(V1q.*5./60);
V2q = interp2(X,Y,S2,Xq,Yq);
V2f = rot90(V2q);
V3q = interp2(X,Y,S3,Xq,Yq);
V3f = rot90(V3q);
figure(1)
imagesc(XX,XX,V1f,[0 4.5])%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
% persistence tim
v = [pt,pt];
contour(Xq,Yq,V1f,v,'k','linewidth',3)
v = [pt+ptsm,pt+ptsm];
contour(Xq,Yq,V1f,v,'k--','linewidth',1)
v = [pt-ptsm,pt-ptsm];
contour(Xq,Yq,V1f,v,'k--','linewidth',1)
% persistence time
v = [pt2,pt2];
contour(Xq,Yq,V1f,v,'y','linewidth',3)
v = [pt2+ptsm2,pt2+ptsm2];
contour(Xq,Yq,V1f,v,'y--','linewidth',1)
v = [pt2-ptsm2,pt2-ptsm2];
contour(Xq,Yq,V1f,v,'y--','linewidth',1)
% unicity
v = [pu,pu];
contour(Xq,Yq,V2f,v,'y','linewidth',3)
v = [pu+pusm,pu+pusm];
contour(Xq,Yq,V2f,v,'y--','linewidth',1)
v = [pu-pusm,pu-pusm];
contour(Xq,Yq,V2f,v,'y--','linewidth',1)
% unicity
v = [pu2,pu2];
contour(Xq,Yq,V2f,v,'k','linewidth',3)
v = [pu2+pusm2,pu2+pusm2];
contour(Xq,Yq,V2f,v,'k--','linewidth',1)
v = [pu2-pusm2,pu2-pusm2];
contour(Xq,Yq,V2f,v,'k--','linewidth',1)

yticks([0 0.5 1]);
yticklabels({'1','0.5','0'})
saveas(gcf,'WTvsGCA.png')
%%
figure(2)
imagesc(XX,XX,V2f)%,[],'initialmagnification',5000);colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
colormap('jet');colorbar;set(gca,'FontSize',24,'fontweight','bold')
hold on
% % persistence tim
% v = [pt,pt];
% contour(Xq,Yq,V1f,v,'k','linewidth',3)
% v = [pt+ptsm,pt+ptsm];
% contour(Xq,Yq,V1f,v,'k--','linewidth',1)
% v = [pt-ptsm,pt-ptsm];
% contour(Xq,Yq,V1f,v,'k--','linewidth',1)
% % persistence time
% v = [pt2,pt2];
% contour(Xq,Yq,V1f,v,'k','linewidth',3)
% v = [pt2+ptsm2,pt2+ptsm2];
% contour(Xq,Yq,V1f,v,'k--','linewidth',1)
% v = [pt2-ptsm2,pt2-ptsm2];
% contour(Xq,Yq,V1f,v,'k--','linewidth',1)
% unicity
v = [pu,pu];
contour(Xq,Yq,V2f,v,'y','linewidth',3)
v = [pu+pusm,pu+pusm];
contour(Xq,Yq,V2f,v,'y--','linewidth',1)
v = [pu-pusm,pu-pusm];
contour(Xq,Yq,V2f,v,'y--','linewidth',1)
% unicity
v = [pu2,pu2];
contour(Xq,Yq,V2f,v,'k','linewidth',3)
v = [pu2+pusm2,pu2+pusm2];
contour(Xq,Yq,V2f,v,'k--','linewidth',1)
v = [pu2-pusm2,pu2-pusm2];
contour(Xq,Yq,V2f,v,'k--','linewidth',1)

yticks([0 0.5 1]);
yticklabels({'1','0.5','0'})
saveas(gcf,'WTvsGCAuni.png')
